package parser;

/**
 * Factory for T1a grammar non-terminal objects.
 */
public class T1aFact extends ATVFactory {
    /**
     * Factory to parse T grammar non-terminals.
     */
    private TFact _tFact;

    /**
     * Token visitor to parse T grammar non-terminals.
     */
    private ITokVisitor _parseT;

    /**
     * Initializer lambda for this factory.
     */
    private ILambda _initializer = new ILambda() {
        public Object apply(Object param) {
            // change state to no-op
            _initializer = NoOpLambda.Singleton;

            // initialize
            _parseT = _tFact.makeVisitor();
            return null;
        }
    };

    /**
     * Constructor for the T1a factory.
     *
     * @param tkz   tokenizer to use
     * @param tFact factory for T grammar non-terminals
     */
    public T1aFact(ITokenizer tkz, TFact tFact) {
        super(tkz);
        _tFact = tFact;
    }

    /**
     * Nake visitor.
     */
    private void initialize() {
        _initializer.apply(null);
    }

    /**
     * Constructor for the E1a factory, Does not take a factory for E grammar non-terminals. That factory has to be set
     * using setParseEFactory().
     *
     * @param tkz tokenizer to use
     */
    public T1aFact(ITokenizer tkz) {
        super(tkz);
    }

    /**
     * Set the factory for T grammar non-terminals.
     *
     * @param tFact factory for T grammar non-terminals
     */
    public void setParseTFactory(TFact tFact) {
        _tFact = tFact;
    }

    /**
     * Make an E1a grammar non-terminal.
     *
     * @param host mult token
     * @param inp  visitor-specific input
     * @return E1a grammar non-terminal
     */
    private T1a makeT1a(MultToken host, Object inp) {
        return new T1a(host, (T) nextToken().execute(_parseT, inp));
    }


    /**
     * Make a token visitor to parse an E1a non-terminal.
     *
     * @return token visitor
     */
    public ITokVisitor makeVisitor() {
        initialize();
        return new MultToken.IMultVisitor() {
            public Object multCase(MultToken host, Object inp) {
                return makeT1a(host, inp);
            }

            public Object defaultCase(AToken host, Object param) {
                throw new IllegalArgumentException("Wrong token: '" + host + "'");
            }
        };
    }

    /**
     * Make a token visitor that delegates to the given visitor in a chain of responsibility.
     *
     * @param successor visitor to serve as successor in the chain
     */
    public ITokVisitor makeChainedVisitor(ITokVisitor successor) {
        initialize();
        return new MultToken.AChainVis(successor) {
            public Object multCase(MultToken host, Object inp) {
                return makeT1a(host, inp);
            }
        };
    }
}

